unit [!UnitName];
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel;

type
  /// <summary>
  /// Summary description for My[!CustomControlName].
  /// </summary>
  [DefaultProperty('Text'),
   ToolboxData('<{0}:My[!CustomControlName] runat=server></{0}:My[!CustomControlName]>')]
  My[!CustomControlName] = class(System.Web.UI.WebControls.WebControl)
  strict private
    FText: String;
  strict protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl 
    procedure RenderContents(Output: HtmlTextWriter); override;
    
   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]
    property Text: string read FText write FText;
  end;

implementation

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor My[!CustomControlName].Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure My[!CustomControlName].RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure My[!CustomControlName].Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

end.
